// main.cpp : wqDxε{iJIC
//

#include "stdafx.h"
#include <iostream>
#import "USGLib.tlb" raw_interfaces_only

using namespace std;
using namespace USGLib;

int _tmain(int argc, _TCHAR* argv[])
{
	// Initialize the COM interface
	HRESULT hr = CoInitialize(NULL);
	
	try{
		// Make a smart pointer to the USGLib interface in DLL
		USGLibInterfacePtr pUSGLibInterface(__uuidof(USGClass));

		// Open Port "COM1"
		BSTR portName = ::SysAllocString(L"COM1");
		BSTR result;
		_bstr_t tmp;
		char* resultString;
		int resultCode;
		
		hr = pUSGLibInterface->OpenDevice(portName, &result);
		tmp = result;
		resultCode = _wtoi(tmp);
		if(resultCode == 0){
			hr = pUSGLibInterface->Initial(&result);
			hr = pUSGLibInterface->GetModel(&result);
			tmp = result;
			resultString = tmp;
			cout << "Device : " << resultString << '\n';
			hr = pUSGLibInterface->SetFreq(2600, &result);
			tmp = result;
			resultCode = _wtoi(tmp);
			if(resultCode == 0){
				cout << "Freq Set Success!!" << '\n';
			}
		}
		else{
			cout << "Error Code : " << resultCode << '\n';
		}	   
	}
	catch(_com_error& e){
		cout << "COM Exception : " << (LPCTSTR)e.Description() << ":" << (LPCTSTR)e.ErrorMessage() << '\n';
	}
	catch(const std::exception &e) {
		cout << "STD Exception : " << e.what() << '\n';
	}
	catch(...){
		cout << "Exception!" << '\n';
	}
	// Release the COM interface
	CoUninitialize();
	system("pause");
	return 0;
}

